-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
-- standardFont = "fonts/dinko_ssk.mvec";
standardFont = "fonts/helvetica_rounded_lt_std.mvec";
-- comicsFont = "fonts/expostb.mvec";
comicsFont = "fonts/dom_casual_std.mvec";
copyrightFont = "fonts/expostb.mvec";

------------------------------	Game Mode enumeration define in setting.h
eStoryMode			= 0;	--	
eFitnessEasy		= 1;	--
eFitnessMedium		= 2;	--
eFitnessHard		= 3;	--
eTugEasy			= 4;	--
eTugMedium			= 5;	--
eTugHard			= 6;	--
eEndless			= 7;	--
eEndlessFitness		= 8;	--
eEndlessTugOfWar	= 9;	--
------------------------------

szNameButtonClick = "audio/sfx/button_click.ogg";
szRollOverSound = "audio/sfx/button_rollover.ogg";


kPopUpGeneralX		= 188;
kPopUpGeneralY		= 81;
BlackColor			= Color(0,0,0,255);
GreenColor			= Color(0,255,0,255);
BlueColor			= Color(77,115,178,255);
RedColor			= Color(255,0,0,255);
DarkBlueColor		= Color(40,60,120,255);
WhiteColor			= Color(255,255,255,255);
MenuButtonFontColor = Color(255,255,255,255);

BackColor			= Color(255,0,0,255);
ContinueColor		= Color(30,229,202,255);
NewGameColor		= Color(23,244,4,255);
ChangePlayerColor	= Color(118,80,206,255);

MetaHeaderColor = Color(0,0,0);
MetaValueColor  = Color(0,0,0);
GreenFitness	= Color(153,255,0,255);
AquaColor		= Color(176,243,228,255);

MenuFitnessTextButtonColor = Color(104,199,194,255);

NormalFontHelp = {
	standardFont,
	11,
	AquaColor
};
WelcomeFont = {
  standardFont,
  30,
  AquaColor
};

ComicFont = {
  comicsFont,
  14,
  BlackColor
};
ComicFont2 = {
  comicsFont,
  18,
  BlackColor
};

StandardButtonGraphics = {
	"images/buttons/buttonup",
	"images/buttons/buttondown",
	"images/buttons/buttonrollover"
};
--Generic style for fitness dash////////////////////////
FitnessButtonMedium = {
	"images/ui/buttons/btn_med_idle.png",
	"images/ui/buttons/btn_med_dwn.png",
	"images/ui/buttons/btn_med_hlt.png"
};
FitnessButtonSmall = {
	"images/ui/buttons/btn_sml_idle.png",
	"images/ui/buttons/btn_sml_dwn.png",
	"images/ui/buttons/btn_sml_hlt.png"
};
FitnessButtonXL = {
	"images/ui/buttons/btn_xl_idle.png",
	"images/ui/buttons/btn_xl_dwn.png",
	"images/ui/buttons/btn_xl_hlt.png"
};

FitnessArrowRight = {
	"images/buttons/arrowright_up.png",
	"images/buttons/arrowright_down.png",
	"images/buttons/arrowright_over.png"
};
FitnessMenuShort = {
	"images/buttons/menu_idle_short.png",
	"images/buttons/menu_down_short.png",
	"images/buttons/menu_hl_short.png"
};

LongButtonGraphics = {
	"images/buttons/long_button_up.png",
	"images/buttons/long_button_down.png",
	"images/buttons/long_button_over.png"
};

CheckboxButtonGraphics = {
	"images/buttons/checkup",
	"images/buttons/checkdown",
	"images/buttons/checkover",
	"images/buttons/checkdownover"
};

StandardButtonFont = {
  standardFont,
  12,
  BlackColor
};

MenuButtonFont = {
  standardFont,
  22,
  MenuButtonFontColor
};
MenuButtonFont2 = {
  standardFont,
  12,
  MenuButtonFontColor
};
MenuButtonFont3 = {
  standardFont,
  10,
  MenuButtonFontColor
};

DialogTitleFont = {
  standardFont,
  20,
  WhiteColor
};

DialogBodyFont = {
  standardFont,
  14,
  WhiteColor
};

FitnessButtonStyleSource = {
	font		= standardFont,
	policeSize	= 8,
	type		= kPush,
	color		= MenuFitnessTextButtonColor,
	sound		= szNameButtonClick,
	mask		= ""
};
FitnessButtonStyleSource2 = {
	font		= standardFont,
	policeSize	= 11,
	type		= kPush,
	color		= MenuFitnessTextButtonColor,
	sound		= szNameButtonClick,
	mask		= ""
};

FitnessButtonStyleSmall = {
	graphics		= FitnessButtonSmall,
	buttonAttribut	= FitnessButtonStyleSource,
	w				= 68,
	h				= 57,
	tx				= -1,	-- x axe for text from center of asset button
	ty				= 14,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= -6	-- y axe for icon from center of asset button
};

FitnessButtonStyleMedium = {
	graphics		= FitnessButtonMedium,
	buttonAttribut	= FitnessButtonStyleSource2,
	w				= 104,
	h				= 70,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 16,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= -6	-- y axe for icon from center of asset button
};

FitnessButtonStyleXL = {
	graphics		= FitnessButtonXL,
	buttonAttribut	= FitnessButtonStyleSource,
	w				= 113,
	h				= 48,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 10,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= -6	-- y axe for icon from center of asset button
};
DefaultStyle = {
	font=DialogBodyFont
};

DialogTitleText = {
	parent=DefaultStyle,
	font = DialogTitleFont,
	flags = kVAlignCenter + kHAlignLeft,
	x=16,y=12,w=kMax,h=30
};

DialogBodyText = {
	parent=DefaultStyle,
	font = DialogBodyFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};

SliderStyle =
{
	parent=DefaultStyle,
	railtop = "images/slider/sliderrailtop",
	railmid = "images/slider/sliderrailmid",
	railbot = "images/slider/sliderrailbot",
	sliderimage = "images/slider/sliderknob",
	sliderrollimage = "images/slider/sliderknobover",

	yoffset = -1, -- scoot the slider down by one pixel to center it.
};

kDefaultButtonSound=szNameButtonClick;

MenuButtonStyle = {
	parent = DefaultStyle,
	font = MenuButtonFont,
	sound = kDefaultButtonSound,
	graphics = {},
	w=169, h=40
};

ButtonStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = StandardButtonGraphics,
};

LongButtonStyle = {
	parent = ButtonStyle,
	graphics = LongButtonGraphics
};	
CheckboxButtonStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	type = kToggle,
	sound = kDefaultButtonSound,
	graphics = CheckboxButtonGraphics,
};

SetDefaultStyle(DefaultStyle);

-- Create a TButton with a label
--
-- We're overriding the default "Button" here with
-- some custom behavior. Specifically, we're layering
-- a Text{} object on top of every button, and it's placed
-- on all layers (up, down, roll-over).
function Button( button )
	return function()
		-- Grab the label from the button or current style
		if (GetTag(button,"label")) then

			-- Look for text dimensions
			local tx = GetTag(button,"tx");
			local ty = GetTag(button,"ty");
			local tw = GetTag(button,"tw");
			local th = GetTag(button,"th");

			-- Set defaults
			if (not tx) then
				tx = 0;
			end
			if (not ty) then
				ty = 0;
			end
			if (not tw) then
				tw=kMax ;
			end
			if (not th) then
				th=kMax ;
			end

			-- Get the label
			local label = GetTag(button,"label");

			local defflags = kPushButtonAlignment ;
			if (GetTag(button,"type")==kToggle) then
				defflags = kToggleButtonAlignment ;
			elseif (GetTag(button,"type")==kRadio) then
				defflags = kRadioButtonAlignment ;
			end

			local textfactory = GetTag(button,"textfactory");
			if (not textfactory) then
				textfactory = "_text"
			end
			table.insert(button,
				SelectLayer( kAllLayers )
			);
			-- Grow our window to encompass any children we've added
			-- already.
			table.insert(button,
				FitToChildren()
			);

			table.insert(button,
				AppendStyle{ font=button.font; flags=button.flags; }
			);

			table.insert(button,
				Text
				{
					label=label,
					x=tx, y=ty, w=tw, h=th,
					name='label',
					defflags =defflags
				}
			)
		end

		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename='Button';
		DoWindow( button )
	end
end

-- Create several bits of text that combine to make a blended shadow
function ColorShadowText( x,y,size, label, color )

	return Group(
		{
		-- Add these traits to the current style
			AppendStyle{ x=x, y=y, w=kMax, h=kMax, label=label },
			AppendStyle{ font = { standardFont, size, Color(0,0,0,40)} },
			Text{ y=y+4 },
			AppendStyle{ font = { standardFont, size, Color(0,0,0,255)} },
			Text{ y=y+2 },
			AppendStyle{ font = { standardFont, size, color } } ,
			Text{},
		}
	)
end

kMenuButtonFontSize = 22;

function MenuButtonLabel( label, color, colorHighlight )

	if not color then
		color =Color(192,207,255,255);	-- the default colors
		colorHighlight=Color(255,255,255,255)
	end

	return Group{
		Bitmap
		{
			image="images/backgrounds/bar",
			x=0,y=0,scale=1
		},
		SelectLayer(0),
		ColorShadowText(5,8,kMenuButtonFontSize, label, color ),
		SelectLayer(1),
		ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight ),
		SelectLayer(2),
		ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight )
	}

end

-- Create a TButton with a label
--
-- We're overriding the default "Button" here with
-- some custom behavior. Specifically, we're layering
-- a Text{} object on top of every button, and it's placed
-- on all layers (up, down, roll-over).
function Button( button )
	return function()
		-- Grab the label from the button or current style
		if (GetTag(button,"label")) then

			-- Look for text dimensions
			local tx = GetTag(button,"tx");
			local ty = GetTag(button,"ty");
			local tw = GetTag(button,"tw");
			local th = GetTag(button,"th");

			-- Set defaults
			if (not tx) then
				tx = 0;
			end
			if (not ty) then
				ty = 0;
			end
			if (not tw) then
				tw=kMax ;
			end
			if (not th) then
				th=kMax ;
			end

			-- Get the label
			local label = GetTag(button,"label");

			local defflags = kPushButtonAlignment ;
			if (GetTag(button,"type")==kToggle) then
				defflags = kToggleButtonAlignment ;
			elseif (GetTag(button,"type")==kRadio) then
				defflags = kRadioButtonAlignment ;
			end

			local textfactory = GetTag(button,"textfactory");
			if (not textfactory) then
				textfactory = "_text"
			end
			table.insert(button,
				SelectLayer( kAllLayers )
			);
			-- Grow our window to encompass any children we've added
			-- already.
			table.insert(button,
				FitToChildren()
			);

			table.insert(button,
				AppendStyle{ font=button.font; flags=button.flags; }
			);

			table.insert(button,
				Text
				{
					label=label,
					x=tx, y=ty, w=tw, h=th,
					name='label',
					defflags =defflags
				}
			)
		end

		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename='Button';
		DoWindow( button )
	end
end
kIllegalNameChars = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:-";